/**
* \file: am_api_events.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AM_API_EVENTS_H
#define AM_API_EVENTS_H

#include "automounter_types.h"
#include "automounter_api_events.h"
#include "ipc/info_messages.h"

void am_api_events_register_callbacks(const automounter_api_callbacks_t *callback_funcs);

void am_api_events_signal_establish_connection_success(void);

void am_api_events_signal_establish_connection_failure(void);

void am_api_events_signal_connection_lost(void);

void am_api_events_on_application_event_message_received(message_buffer_t *recvr_buffer);

event_mask_t am_api_events_get_callback_mask(void);

#endif
